/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_10;

import djbuch.kapitel_06.DemoTools;
import lotus.domino.*;

/**
 * @author Thomas Ekert
 *
 */
public class DJLoopCommandDumpDoc extends DJLoopCommand {

	private final int size;
	private int count=1;
	
	public DJLoopCommandDumpDoc(View view) throws NotesException {
		super(view);
		size = view.getAllEntries().getCount();
	}
	/**
	 * @param doc - Dokument, auf dem die Aktion ausgefhrt wird
	 * @return - false, falls die Loopaktion abgebrochen werden soll.
	 */
	public boolean execute(Document doc) throws NotesException {		
		System.out.println ("Dokument " + count++ + " / " + size);
		DemoTools.dumpDoc(doc);
		return true;
	}
	
	public int getSize() {
		return size;
	}

}
